/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.graphics;

import org.eclipse.swt.*;

public final class Color extends Resource {
	public int handle;

Color(Device device) {
	super(device);
}
	
public Color (Device device, int red, int green, int blue) {
	super(device);
	init(red, green, blue);
	init();
}

public Color (Device device, RGB rgb) {
	super(device);
	init(rgb.red, rgb.green, rgb.blue);
	init();
}

void destroy () {
	handle = -1;
}

public boolean equals (Object object) {
	if (object == this) return true;
	if (!(object instanceof Color)) return false;
	Color color = (Color) object;
	return device == color.device && (handle & 0xFFFFFF) == (color.handle & 0xFFFFFF);
}

public int getBlue () {
	if (isDisposed()) SWT.error(SWT.ERROR_GRAPHIC_DISPOSED);
	return handle & 0xFF;
}

public int getGreen () {
	if (isDisposed()) SWT.error(SWT.ERROR_GRAPHIC_DISPOSED);
	return (handle & 0xFF00) >> 8;
}

public int getRed () {
	if (isDisposed()) SWT.error(SWT.ERROR_GRAPHIC_DISPOSED);
	return (handle & 0xFF0000) >> 16;
}

public RGB getRGB () {
	if (isDisposed()) SWT.error(SWT.ERROR_GRAPHIC_DISPOSED);
	return new RGB((handle & 0xFF0000) >> 16, (handle & 0xFF00) >> 8, handle & 0xFF);
}

public int hashCode () {
	if (isDisposed()) return 0;
	return handle;
}

void init(int red, int green, int blue) {
	if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
		SWT.error(SWT.ERROR_INVALID_ARGUMENT);
	}
	handle = ((red & 0xFF) << 16) | ((green & 0xFF) << 8) | (blue & 0xFF);
}

public boolean isDisposed () {
	return handle == -1;
}

public String toString () {
	if (isDisposed()) return "Color {*DISPOSED*}"; //$NON-NLS-1$
	return "Color {" + getRed() + ", " + getGreen() + ", " + getBlue() + "}"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
}

public static Color flex_new (Device device, int rgb) {
	Color color = new Color(device);
	color.handle = rgb;
	return color;
}

}
